CODE       SEGMENT
           ASSUME      CS:CODE,DS:CODE

;----------------------------------------------------------
; Funktion:     Abaendern der ISR fuer Fatal Error
; Betriebssystem: MS DOS
; Autor:        M. Lutz
;----------------------------------------------------------

           JMP        ANFANG

; Konstantendefinition
BELL       EQU        07H   ; Code fuer die Tonausgabe

; Codebereich
ANFANG:

; Lesen der Adresse der ISR fuer Interrupt 24H
; und Ablegen in ES:DI

           MOV        BX,0
           MOV        DS,BX
           MOV        BX,90H
           MOV        DI,[BX]
           INC        BX
           INC        BX
           MOV        AX,[BX]
           MOV        ES,AX


; Einstellen von DS und SI fuer eine Datenuebertragung

           MOV        AX,CS
           MOV        DS,AX
           MOV        SI,OFFSET ISRTIM
           MOV        CX,OFFSET ISRENDE
           SUB        CX,SI

; neue ISR an den Speicherplatz der alten ISR kopieren

           REP MOVSB

; Programm beenden

           MOV        AX,4C00H
           INT        21H

; neue ISR

ISRTIM:
           STI
           PUSH       AX   ; die benutzten Register im Stack
           PUSH       DX   ; ablegen
           PUSH       CX

ISRLOOP:
           MOV        CX,1000

WART:
           MOV        AH,0BH      ; pruefe Tastaturstatus
           INT        21H

           CMP        AL,0FFH
           JZ         ISREND      ; Taste gedrueckt -> Ende

           DEC        CX          ; etwas warten
           JNZ        WART

           MOV        DL,BELL     ; Code fuer Glocke nach DL
           MOV        AH,06H
           INT        21H

           JMP        ISRLOOP     ; weiter warten

ISREND:
           POP        CX
           POP        DX
           POP        AX          ; Register aus Stack

           IRET                   ; Ende der ISR

ISRENDE:

CODE       ENDS

           END

